<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:variable name="uniqueOffsetAlignment" select="//StationOffsetPoints/StationOffsetPoint[not (@offsetAlignmentName = preceding-sibling::StationOffsetPoint/@offsetAlignmentName)]/@offsetAlignmentName"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Základní staničeni Výškový rozdíl</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Základní staničeni Výškový rozdíl</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right">Základní (Aktivní) trasa:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="HorizontalAlignment/@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <xsl:for-each select="$uniqueOffsetAlignment">
                                    <table class="margin" cellpadding="2" width="75%">
                                        <thead>
                                            <tr>
                                                <th class="underline" lang="en" valign="bottom">
                                                    Aktivní trasa<br/>Staničení<br/>
                                                    (<xsl:value-of select="../../../@name"/>)
                                                </th>
                                                <th class="underline" lang="en" valign="bottom">Typ</th>
                                                <th class="underline" lang="en">
                                                    Kolmá vzdálenost<br/>od aktivní trasy<br/>k definované trase
                                                    <br/>Odstup je <xsl:value-of select="cif:distanceFormat(number(../@secondOffset))"/>
                                                    <br/>(<xsl:value-of select="."/>)
                                                </th>
                                                <th class="underline" lang="en" valign="bottom">
                                                    Výškový rozdíl<br/>k<xsl:value-of select="."/>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr><td colspan="4">&#xa0;</td></tr>
                                            <xsl:for-each select="//StationOffsetPoint[@offsetAlignmentName = current()]">
                                                <tr>
                                                    <td align="right" class="sidepad">
                                                        <xsl:value-of select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation), string(centerLinePoint/point/station/@externalStationName))"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="centerLinePoint/point/@type"/>
                                                    </td>
                                                    <td align="right" class="sidepad">
                                                        <xsl:value-of select="cif:distanceFormat(number(@firstOffset))"/>
                                                    </td>
                                                    <td align="right" class="sidepad">
                                                        <xsl:value-of select="cif:ordinateFormat(number(centerLinePoint/point/@elevation - offsetLinePoint/point/@elevation))"/>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                            <tr><td colspan="4">&#xa0;</td></tr>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíže vyvtořit body ve staničení a odstupu pomocí <em>Nástroje &gt; XML výpisy &gt; Základní staničení</em>.
            </p>
            <p class="normal1" lang="en">
                musíte vybrat nejméně jedno směrové řešení nebo jeden prvek v listu <em>Obecně</em>, v poli <em>Z</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte také vybrat nejméně jedno směrové řešení v listu <em>Směrová řešení</em> nebo prvek v listu <em>Prvky</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jednu volbu v listu <em>Zahrnout</em> (<em>
                    Směrové body - Na trase, Významné, 
					Výškové body - Na trase, Významné
                </em> nebo <em>Interval</em>.)
            </p>
            <p class="normal1" lang="en">
                <em>Staničení Limity</em>použijte pouze na spočtená data, např. body pomocí Interval.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2013 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
